set more 1
log using macro_q.log,replace

/* look at effect of gdp on total hours, and total hours on hour per worker
   and see in which case 2009 looks unpredicted (for Germany)
   data are from BLS except for the total hours data, from the SVR 
   also have std hours in metal-working for Arbeiter - IG Metall
   GDP numbers are single series for whole period 

*/

* read in the Stabu quarterly data

use /Users/hunt/Desktop/Nervecenter/research/BPEA_recession/data/Stabu/stabu70_10

* merge in annual pop (year's average)
sort year
merge year using /Users/hunt/Desktop/Nervecenter/research/BPEA_recession/data/Stabu/pop
tab _merge
* have from 1950, missing 2010
drop if year<1970
drop _merge

* make quarter dummies
tab quarter,gen(qdum)

* merge in the BLS unemployment rates
*sort year
*merge year using /Users/hunt/Desktop/Nervecenter/research/data-sets/germstat/bls6.dta
*tab year_q _merge if _merge~=3
*drop _merge

* merge in the Kurzarbeitergeld spending (yearly)
sort year
merge year using ~/research/BPEA_recession/data/Stabu/kug
tab _merge
drop _merge

* merge on the quarterly info about hours lost to KA so as to make
* the payments on KA into quarterly
* use the seasonally unadjusted file, or there are negative numbers
sort year_q
merge year_q using /Users/hunt/Desktop/Nervecenter/research/BPEA_recession/data/IAB/arbeitszeit_q_seas
tab _merge 
drop _merge
* NB contains  iarbeitnehmer* konto* uberstunden* time* NOT seasonally adj

* merge on value-added by industry
sort year_q
merge year_q using /Users/hunt/Desktop/Nervecenter/research/BPEA_recession/data/Stabu/stabu_ind
tab _merge
drop _merge

* merge on labor force
sort year_q
merge year_q using /Users/hunt/Desktop/Nervecenter/research/BPEA_recession/data/Stabu/laborforce
tab _merge
drop _merge

* merge on IFO expectations which have been made into quarterly from monthly
sort year_q
merge year_q using /Users/hunt/Desktop/Nervecenter/research/BPEA_recession/data/IFO/ifo_q
tab _merge
drop _merge

* merge on Michael's HP filtered employment
sort year_q
merge year_q using /Users/hunt/Desktop/Nervecenter/research/BPEA_recession/data/Stabu/hplempl
tab _merge
drop _merge
drop lempl

* change Kurzarbeit expenses that are in DM to Euro, impute some values
do ~/research/BPEA_recession/statprog/kug

* make vars into one year, normalizing with Q1 1991
* GDP
* make nominal and real gdp into one series each (real is index, w:1991=100 u:2000=100)
*gen gdp_r=gdp_r_w
*replace gdp_r=gdp_r_u*(99.9/86.01) if year>=1991
gen gdp_r=gdp_r_u
replace gdp_r=gdp_r_w*(86.01/99.9) if year<1991

*gen gdp_n=gdp_w_n
*replace gdp_n=gdp_u_n*(344.72/372.09) if year>=1991
gen gdp_n=gdp_u_n
replace gdp_n=gdp_w_n*(372.09/344.72) if year<1991

drop gdp_w_n gdp_u_n gdp_r_u gdp_r_w

* get the gdp deflator by dividing nominal and real
* this gives slightly more inflation right after unification than Gartner
* he must have normalized 1991 differently
gen gdp_def=100*(gdp_n/gdp_r)
* make gdp deflator equal 100 in 2000 Q1
replace gdp_def=100*(gdp_def/520.3448)

* hours worked
*gen hourswork=hourswork_w
*replace hourswork=hourswork_u*(12170/15173) if year>=1991
gen hourswork=hourswork_u
replace hourswork=hourswork_w*(15173/12170) if year<1991
drop hourswork_w hourswork_u

* employment
*gen empl=empl_w
*replace empl=empl_u*(31033/39008) if year>=1991
gen empl=empl_u
replace empl=empl_w*(39008/31033) if year<1991
drop empl_w empl_u

* deflate gross wages and make into one year using Q1 1991
*gen wageh_n=verdienstjestunde_w
*replace wageh_n=verdienstjestunde_u*1.130 if year>=1991
gen wageh_n=verdienstjestunde_u
replace wageh_n=verdienstjestunde_w/1.130 if year<1991
drop verdienstjestunde*
gen wageh_r=(wageh_n/gdp_def)*100
label var wageh_r "real hourly gross wage"
label var wageh_n "nominal hourly gross wage"

* same thing for exports
* note: in 1991 unified exports are lower than western exports
* presumably bc western exports to east are not exports under unified accounts
*gen exports_n=exports_w_n
*replace exports_n=exports_u_n*(115.14/100.07) if year>=1991
gen exports_n=exports_u_n
replace exports_n=exports_w_n*(100.07/115.14) if year<1991
gen exports_r=(exports_n/gdp_def)*100
drop exports_w_n exports_u_n
label var exports_r "Real exports"

* same for imports
*gen imports_n=imports_w_n
*replace imports_n=imports_u_n*(98.65/99.94) if year>=1991
gen imports_n=imports_u_n
replace imports_n=imports_w_n*(99.94/98.65) if year<1991
gen imports_r=(imports_n/gdp_def)*100
drop imports_w_n imports_u_n
label var imports_r "Real imports"

* same thing for private consumption
*gen cons_n=cons_w_n
*replace cons_n=cons_u_n*(190.1/214.28) if year>=1991
gen cons_n=cons_u_n
replace cons_n=cons_w_n*(214.28/190.1) if year<1991
gen cons_r=(cons_n/gdp_def)*100
drop cons_u_n cons_w_n
label var cons_r "Real private consumption"

* same thing for gross investments
*gen invest_n=invest_w_n
*replace invest_n=invest_u_n*(79.57/91.76) if year>=1991
gen invest_n=invest_u_n
replace invest_n=invest_w_n*(91.76/79.57) if year<1991
gen invest_r=(invest_n/gdp_def)*100
drop invest_u_n invest_w_n
label var invest_r "Real gross investment"

* same thing for govt consumption spending
*gen govt_n=govt_w_n
*replace govt_n=govt_u_n*(60.57/67.71) if year>=1991
gen govt_n=govt_u_n
replace govt_n=govt_w_n*(67.71/60.57) if year<1991
gen govt_r=(govt_n/gdp_def)*100
drop govt_u_n govt_w_n
label var govt_r "Real government consumption spending"

* same thing for labor costs including both SS components (Arbeitnehmerentgelt)
*gen entgeltAN_n=entgeltAN_w_n
*replace entgeltAN_n=entgeltAN_u_n*0.8829 if year>=1991
gen entgeltAN_n=entgeltAN_u_n
replace entgeltAN_n=entgeltAN_w_n/0.8829 if year<1991
gen entgeltAN_r=(entgeltAN_n/gdp_def)*100
label var entgeltAN_r "real Arbeitnehmerentgelt - total"
label var entgeltAN_n "nominal Arbeitnehmerentgelt - total"

* similar for value added by industry
do ~/research/BPEA_recession/statprog/cleanind

* same thing for engelt per AN ie Lohnkosten je AN - don't use Stabu-calculated var
* entgelt in Mrd, arbeitnehmer in 000s, make into mthly like Stabu data
drop lohnkostenjeAN*
gen costperl_w_n=(1000000/3)*entgeltAN_w_n/arbeitnehmer_w
gen costperl_u_n=(1000000/3)*entgeltAN_u_n/arbeitnehmer_u
*gen costperl_n=costperl_w_n
*replace costperl_n=costperl_u_n*(2159/1921) if year>=1991
gen costperl_n=costperl_u_n
replace costperl_n=costperl_w_n*(1921/2159) if year<1991
drop costperl_u_n costperl_w_n
gen costperl_r=(costperl_n/gdp_def)*100
label var costperl_n "nominal AN Entgelt/AN"
label var costperl_r "real AN Entgelt/AN"

* same thing for hours worked
*gen stundenAN=stundenAN_w
*replace stundenAN=stundenAN_u*(10612/13218) if year>=1991
gen stundenAN=stundenAN_u
replace stundenAN=stundenAN_w*(13218/10612) if year<1991
label var stundenAN "hours worked per AN"

* same thing for arbeitnehmer from stabu
*gen arbeitnehmer=arbeitnehmer_w
*replace arbeitnehmer=arbeitnehmer_u*(27895/35513) if year>=1991
gen arbeitnehmer=arbeitnehmer_u
replace arbeitnehmer=arbeitnehmer_w*(35513/27895) if year<1991

* calculate entgelt per hour
gen costperh_w_n=1000*entgeltAN_w_n/stundenAN_w
gen costperh_u_n=1000*entgeltAN_u_n/stundenAN_u
*gen costperh_n=costperh_w_n
*replace costperh_n=costperh_u_n*(17.54/15.48) if year>=1991
gen costperh_n=costperh_u_n
replace costperh_n=costperh_w_n*(15.48/17.54) if year<1991
gen costperh_r=(costperh_n/gdp_def)*100

* same thing for worker SS contributions
*gen ssAN_n=ssAN_w_n
*replace ssAN_n=ssAN_u_n*0.8909 if year>=1991
gen ssAN_n=ssAN_u_n
replace ssAN_n=ssAN_w_n/0.8909 if year<1991
drop ssAN_w_n ssAN_u_n
gen ssAN_r=(ssAN_n/gdp_def)*100
rename ssAN_r ssworker_r
rename ssAN_n ssworker_n
label var ssworker_r "real worker's social sec. contribs - total"
label var ssworker_n "nominal worker's social sec. contribs - total"

* same thing for employer SS contributions
*gen ssAG_n=ssAG_w_n
*replace ssAG_n=ssAG_u_n*0.8909 if year>=1991
gen ssAG_n=ssAG_u_n
replace ssAG_n=ssAG_w_n/0.8909 if year<1991
drop ssAG_w_n ssAG_u_n
gen ssAG_r=(ssAG_n/gdp_def)*100
rename ssAG_r ssfirm_r
rename ssAG_n ssfirm_n
label var ssfirm_r "real employer's social sec. contribs - total"
label var ssfirm_n "nominal employer's social sec. contribs - total"

* same thing for annual pop
*gen pop=pop_w
*replace pop=pop_u*(64074/79984) if year>=1991
gen pop=pop_u
replace pop=pop_w*(79984/64074) if year<1991
drop pop_u pop_w

* smooth pop over the quarters
gen ho=pop
replace ho=. if quarter~=3
ipolate  ho year_q,gen(npop) epolate
rename pop popy 
label var popy "original yearly population"
rename npop pop 
label var pop "quarterly population, from smoothing yearly"
drop ho

* subtract the KA expenses from the nominal total lohnkosten
* KA expenses are in million Euros, Entgelt in billion euros
gen entgeltANadj_u_n=entgeltAN_u_n-kug_u_n/1000
gen entgeltANadj_w_n=entgeltAN_w_n-kug_w_n/1000
drop entgeltAN_w_n entgeltAN_u_n
drop kug_u_n_y kug_w_n_y kug_e_n_y

* generate real costs per worker, adjusted for the ka payments
* and make into one year: not clear how to normalize ka payments
* so normalize at Q1 1991 using unadjusted ratio
* entgelt in Mrd, arbeitnehmer in 000s, make into mthly like Stabu data
gen costperladj_r_u=((1000000/3)*(entgeltANadj_u_n/arbeitnehmer_u)/gdp_def)*100
gen costperladj_r_w=((1000000/3)*(entgeltANadj_w_n/arbeitnehmer_w)/gdp_def)*100
*gen costperladj_r=costperladj_r_w
*replace costperladj_r=costperladj_r_u*(2159/1921) if year>=1991
gen costperladj_r=costperladj_r_u
replace costperladj_r=costperladj_r_w*(1921/2159) if year<1991
drop costperladj_r_u costperladj_r_w
label var costperladj_r "Real lohnkosten je AN adj for KA Geld"

* same for per hour, hours are in millions of hours
gen costperhadj_r_u=(1000*(entgeltANadj_u_n/stundenAN_u)/gdp_def)*100
gen costperhadj_r_w=(1000*(entgeltANadj_w_n/stundenAN_w)/gdp_def)*100
*gen costperhadj_r=costperhadj_r_w
*replace costperhadj_r=costperhadj_r_u*(17.54/15.48) if year>=1991
gen costperhadj_r=costperhadj_r_u
replace costperhadj_r=costperhadj_r_w*(15.48/17.54) if year<1991
drop costperhadj_r_u costperhadj_r_w
label var costperhadj_r "Real lohnkosten je AN Stunde adj for KA Geld"
drop stundenAN_w stundenAN_u

* calculate total SS contributions as fraction of total entgelt
gen ssfrac=(ssworker_r+ssfirm_r)/(entgeltAN_r)
label var ssfrac "social security contribs as fraction of entgelt"

* calculate total SS contributions
gen sstot_r=ssworker_r+ssfirm_r
label var sstot_r "real social security contributions (both) - total"

* calculate per arbeitnehmer
gen ssperl_r=sstot_r/arbeitnehmer

* post unification dummy
gen byte postunif=1 if year>=1991
replace postunif=0 if year<1991

* dummy for Q1 1991
gen byte year91_1=1 if year==1991&quarter==1
replace year91_1=0 if year~=1991|quarter~=1

* get hours per worker from employment and total hours
* remembering that employment is in 1000s
gen hrsworker=(hourswork*1000000)/(empl*1000)
label var hrsworker "Hours per worker"

* create logs

gen lcostperh_r=log(costperh_r)
gen lcostperl_r=log(costperl_r)
gen lcostperladj_r=log(costperladj_r)
gen lcostperhadj_r=log(costperhadj_r)
gen lwageh_r=log(wageh_r)
gen lhourswork=log(hourswork)
gen lhrsworker=log(hrsworker)
gen lempl=log(empl)
gen lgdp_r=log(gdp_r)
gen lentgeltAN_r=log(entgeltAN_r)
gen lssfrac=log(ssfrac)
gen lcons_r=log(cons_r)
gen lexports_r=log(exports_r)
gen linvest_r=log(invest_r)
gen limports_r=log(imports_r)
gen lgovt_r=log(govt_r)
gen lpop=log(pop)
gen lemplag=log(emplag)
gen lemplman=log(emplman)
gen lemplman_w=log(emplman_w)
gen lemplcons=log(emplcons)
gen lempltrade=log(empltrade)
gen lemplfin=log(emplfin)
gen lemplserv=log(emplserv)
gen lvaag_r=log(vaag_r)
gen lvaman_r=log(vaman_r)
gen lvaman_r_w=log(vaman_r_w)
gen lvacons_r=log(vacons_r)
gen lvatrade_r=log(vatrade_r)
gen lvafin_r=log(vafin_r)
gen lvaserv_r=log(vaserv_r)

label var lempl "Log employment"
label var lhrsworker "Log hours per worker"
label var lhourswork "Log total hours worked"
label var lgdp_r "Log real GDP"
label var linvest_r "Log real investment"

* lagged value of some vars
sort year_q
gen lempll=lempl[_n-1]
gen lhrsworkerl=lhrsworker[_n-1]
gen lhoursworkl=lhourswork[_n-1]
gen lgdp_rl=lgdp_r[_n-1]
gen lcostperh_rl=lcostperh_r[_n-1]
gen lcostperl_rl=lcostperl_r[_n-1]
gen lcostperladj_rl=lcostperladj_r[_n-1]
gen lvaag_rl=lvaag_r[_n-1]
gen lvaman_rl=lvaman_r[_n-1]
gen lvacons_rl=lvacons_r[_n-1]
gen lvatrade_rl=lvatrade_r[_n-1]
gen lvafin_rl=lvafin_r[_n-1]
gen lvaserv_rl=lvaserv_r[_n-1]
gen lcons_rl=lcons_r[_n-1]
gen lexports_rl=lexports_r[_n-1]
gen linvest_rl=linvest_r[_n-1]
gen limports_rl=limports_r[_n-1]
gen lgovt_rl=lgovt_r[_n-1]

sort year_q
gen lhoursworkl2=lhourswork[_n-2]
gen lgdp_rl2=lgdp_r[_n-2]
gen lcostperh_rl2=lcostperh_r[_n-2]
gen lcostperl_rl2=lcostperl_r[_n-2]
gen lcostperladj_rl2=lcostperladj_r[_n-2]
gen lvaag_rl2=lvaag_r[_n-2]
gen lvaman_rl2=lvaman_r[_n-2]
gen lvacons_rl2=lvacons_r[_n-2]
gen lvatrade_rl2=lvatrade_r[_n-2]
gen lvafin_rl2=lvafin_r[_n-2]
gen lvaserv_rl2=lvaserv_r[_n-2]
gen lcons_rl2=lcons_r[_n-2]
gen lexports_rl2=lexports_r[_n-2]
gen linvest_rl2=linvest_r[_n-2]
gen limports_rl2=limports_r[_n-2]
gen lgovt_rl2=lgovt_r[_n-2]

sort year_q
gen lhoursworkl3=lhourswork[_n-3]
gen lgdp_rl3=lgdp_r[_n-3]
gen lcostperh_rl3=lcostperh_r[_n-3]
gen lcostperl_rl3=lcostperl_r[_n-3]
gen lcostperladj_rl3=lcostperladj_r[_n-3]
gen lvaag_rl3=lvaag_r[_n-3]
gen lvaman_rl3=lvaman_r[_n-3]
gen lvacons_rl3=lvacons_r[_n-3]
gen lvatrade_rl3=lvatrade_r[_n-3]
gen lvafin_rl3=lvafin_r[_n-3]
gen lvaserv_rl3=lvaserv_r[_n-3]

sort year_q
gen lhoursworkl4=lhourswork[_n-4]
gen lgdp_rl4=lgdp_r[_n-4]
gen lcostperh_rl4=lcostperh_r[_n-4]
gen lcostperl_rl4=lcostperl_r[_n-4]
gen lcostperladj_rl4=lcostperladj_r[_n-4]
gen lvaag_rl4=lvaag_r[_n-4]
gen lvaman_rl4=lvaman_r[_n-4]
gen lvacons_rl4=lvacons_r[_n-4]
gen lvatrade_rl4=lvatrade_r[_n-4]
gen lvafin_rl4=lvafin_r[_n-4]
gen lvaserv_rl4=lvaserv_r[_n-4]

* generate counterfactual data L cost data
* allow to rise at historic rate from 2003
* either trend, or on top of what actually happened
* bonus1: add trend to existing
gen post2003trend=0 if year<=2003
replace post2003trend=year_q-2003.75 if year>2003
replace post2003trend=post2003trend*4 /* make increment by 1 not .25; new */
gen bonus1=0 if year_q<=2003.75
*replace bonus1=.00812*post2003trend /* typo? should have been .00281? */
replace bonus1=.00281*post2003trend

gen lcostperladj_rcnt1=lcostperladj_r if year<=2003
replace lcostperladj_rcnt1=lcostperladj_r+bonus1 if year>2003
label var lcostperladj_rcnt1 "counterfactual L costs, >2003 add historical trend"
* lag
sort year_q
gen lcostperladj_rcnt1l2=lcostperladj_rcnt1[_n-2]

* bonus2: no cyclical, just rise steadily
* get value of LC in 2003.75
gen ho=lcostperladj_r if year_q==2003.75
egen lcostperladj_r200375=max(ho)
gen lcostperladj_rcnt2=lcostperladj_r if year<=2003
replace lcostperladj_rcnt2=lcostperladj_r200375+bonus1 if year>2003
drop ho
* lag
sort year_q
gen lcostperladj_rcnt2l2=lcostperladj_rcnt2[_n-2]

* counterfactual 3: impose 10 log points wage decline Q4 2008-Q4 2009
gen lcostperladj_rcnt3=lcostperladj_r if year_q<=2008.75
replace lcostperladj_rcnt3=lcostperladj_rcnt3[_n-1]-.025 if year_q==2009
replace lcostperladj_rcnt3=lcostperladj_rcnt3[_n-1]-.025 if year_q==2009.25
replace lcostperladj_rcnt3=lcostperladj_rcnt3[_n-1]-.025 if year_q==2009.5
replace lcostperladj_rcnt3=lcostperladj_rcnt3[_n-1]-.025 if year_q==2009.75
* lag
sort year_q
gen lcostperladj_rcnt3l2=lcostperladj_rcnt3[_n-2]

* counterfactual 4: instead of gradual decline, sudden 10% subsidy 
* in period lots of KA Q1 2009-Q1 2010
gen lcostperladj_rcnt4=lcostperladj_r if year_q<=2008.75|year_q>2010
replace lcostperladj_rcnt4=lcostperladj_r-.1 if year_q==2009
replace lcostperladj_rcnt4=lcostperladj_r-.1 if year_q==2009.25
replace lcostperladj_rcnt4=lcostperladj_r-.1 if year_q==2009.5
replace lcostperladj_rcnt4=lcostperladj_r-.1 if year_q==2009.75
replace lcostperladj_rcnt4=lcostperladj_r-.1 if year_q==2010
* lag
sort year_q
gen lcostperladj_rcnt4l2=lcostperladj_rcnt4[_n-2]

* create differenced variables
sort year_q
gen dlgdp_r=lgdp_r-lgdp_r[_n-1]
gen dlgdp_rl=lgdp_rl-lgdp_rl[_n-1]
gen dlhourswork=lhourswork-lhourswork[_n-1]
gen dlhrsworker=lhrsworker-lhrsworker[_n-1]
gen dlempl=lempl-lempl[_n-1]
gen dlemplman=lemplman-lemplman[_n-1]
gen dlcostperh_r=lcostperh_r-lcostperh_r[_n-1]
gen dlcostperh_rl=lcostperh_rl-lcostperh_rl[_n-1]
gen dlcostperl_r=lcostperl_r-lcostperl_r[_n-1]
gen dlcostperl_rl=lcostperl_rl-lcostperl_rl[_n-1]
gen dlcostperladj_r=lcostperladj_r-lcostperl_r[_n-1]
gen dlcostperhadj_r=lcostperhadj_r-lcostperl_r[_n-1]
gen dlentgeltAN_r=lentgeltAN_r-lentgeltAN_r[_n-1]
gen dlssfrac=lssfrac-lssfrac[_n-1]  /* disapprove, but try anyway */
gen dlpop=lpop-lpop[_n-1]
gen dlcons_r=lcons_r-lcons_r[_n-1]
gen dlgovt_r=lgovt_r-lgovt_r[_n-1]
gen dlinvest_r=linvest_r-linvest_r[_n-1]
gen dlexports_r=lexports_r-lexports_r[_n-1]
gen dlimports_r=limports_r-limports_r[_n-1]
gen dlvaag_r=lvaag_r-lvaag_r[_n-1]
gen dlvaman_r=lvaman_r-lvaman_r[_n-1]
*gen dlvamansub_r=lvamansub_r-lvamansub_r[_n-1]
gen dlvacons_r=lvacons_r-lvacons_r[_n-1]
gen dlvatrade_r=lvatrade_r-lvatrade_r[_n-1]
gen dlvafin_r=lvafin_r-lvafin_r[_n-1]
gen dlvaserv_r=lvaserv_r-lvaserv_r[_n-1]


* create two period differences
sort year_q
gen d2lgdp_r=lgdp_r-lgdp_r[_n-2]
gen d2lgdp_rl=lgdp_rl-lgdp_rl[_n-2]
gen d2lhourswork=lhourswork-lhourswork[_n-2]
gen d2lhrsworker=lhrsworker-lhrsworker[_n-2]
gen d2lempl=lempl-lempl[_n-2]
gen d2lcostperh_r=lcostperh_r-lcostperh_r[_n-2]
gen d2lcostperh_rl=lcostperh_rl-lcostperh_rl[_n-2]
gen d2lcostperl_r=lcostperl_r-lcostperl_r[_n-2]
gen d2lcostperl_rl=lcostperl_rl-lcostperl_rl[_n-2]
gen d2lcostperladj_r=lcostperladj_r-lcostperl_r[_n-2]
gen d2lcostperhadj_r=lcostperhadj_r-lcostperl_r[_n-2]
gen d2lentgeltAN_r=lentgeltAN_r-lentgeltAN_r[_n-2]
gen d2lssfrac=lssfrac-lssfrac[_n-2]  /* disapprove, but try anyway */
gen d2lpop=lpop-lpop[_n-2]
gen d2lcons_r=lcons_r-lcons_r[_n-2]
gen d2lgovt_r=lgovt_r-lgovt_r[_n-2]
gen d2linvest_r=linvest_r-linvest_r[_n-2]
gen d2lexports_r=lexports_r-lexports_r[_n-2]
gen d2limports_r=limports_r-limports_r[_n-2]
gen d2lvaag_r=lvaag_r-lvaag_r[_n-2]
gen d2lvaman_r=lvaman_r-lvaman_r[_n-2]
*gen d2lvamansub_r=lvamansub_r-lvamansub_r[_n-2]
gen d2lvacons_r=lvacons_r-lvacons_r[_n-2]
gen d2lvatrade_r=lvatrade_r-lvatrade_r[_n-2]
gen d2lvafin_r=lvafin_r-lvafin_r[_n-2]
gen d2lvaserv_r=lvaserv_r-lvaserv_r[_n-2]

* create one year differences
sort year_q
gen d4lgdp_r=lgdp_r-lgdp_r[_n-4]
gen d4lgdp_rl=lgdp_rl-lgdp_rl[_n-4]
gen d4lhourswork=lhourswork-lhourswork[_n-4]
gen d4lhrsworker=lhrsworker-lhrsworker[_n-4]
gen d4lempl=lempl-lempl[_n-4]
gen d4lcostperh_r=lcostperh_r-lcostperh_r[_n-4]
gen d4lcostperh_rl=lcostperh_rl-lcostperh_rl[_n-4]
gen d4lcostperl_r=lcostperl_r-lcostperl_r[_n-4]
gen d4lcostperl_rl=lcostperl_rl-lcostperl_rl[_n-4]
gen d4lcostperladj_r=lcostperladj_r-lcostperl_r[_n-4]
gen d4lcostperhadj_r=lcostperhadj_r-lcostperl_r[_n-4]
gen d4lentgeltAN_r=lentgeltAN_r-lentgeltAN_r[_n-4]
gen d4lssfrac=lssfrac-lssfrac[_n-4]  /* disapprove, but try anyway */
gen d4lpop=lpop-lpop[_n-4]
gen d4lcons_r=lcons_r-lcons_r[_n-4]
gen d4lgovt_r=lgovt_r-lgovt_r[_n-4]
gen d4linvest_r=linvest_r-linvest_r[_n-4]
gen d4lexports_r=lexports_r-lexports_r[_n-4]
gen d4limports_r=limports_r-limports_r[_n-4]

* create two year differences
sort year_q
gen d8lgdp_r=lgdp_r-lgdp_r[_n-8]
gen d8lgdp_rl=lgdp_rl-lgdp_rl[_n-8]
gen d8lhourswork=lhourswork-lhourswork[_n-8]
gen d8lhrsworker=lhrsworker-lhrsworker[_n-8]
gen d8lempl=lempl-lempl[_n-8]
gen d8lcostperh_r=lcostperh_r-lcostperh_r[_n-8]
gen d8lcostperh_rl=lcostperh_rl-lcostperh_rl[_n-8]
gen d8lcostperl_r=lcostperl_r-lcostperl_r[_n-8]
gen d8lcostperl_rl=lcostperl_rl-lcostperl_rl[_n-8]
gen d8lcostperladj_r=lcostperladj_r-lcostperl_r[_n-8]
gen d8lcostperhadj_r=lcostperhadj_r-lcostperl_r[_n-8]
gen d8lentgeltAN_r=lentgeltAN_r-lentgeltAN_r[_n-8]
gen d8lssfrac=lssfrac-lssfrac[_n-8]  /* disapprove, but try anyway */
gen d8lpop=lpop-lpop[_n-8]
gen d8lcons_r=lcons_r-lcons_r[_n-8]
gen d8lgovt_r=lgovt_r-lgovt_r[_n-8]
gen d8linvest_r=linvest_r-linvest_r[_n-8]
gen d8lexports_r=lexports_r-lexports_r[_n-8]
gen d8limports_r=limports_r-limports_r[_n-8]

* create three year differences
sort year_q
gen d12lgdp_r=lgdp_r-lgdp_r[_n-12]
gen d12lgdp_rl=lgdp_rl-lgdp_rl[_n-12]
gen d12lhourswork=lhourswork-lhourswork[_n-12]
gen d12lhrsworker=lhrsworker-lhrsworker[_n-12]
gen d12lempl=lempl-lempl[_n-12]
gen d12lcostperh_r=lcostperh_r-lcostperh_r[_n-12]
gen d12lcostperh_rl=lcostperh_rl-lcostperh_rl[_n-12]
gen d12lcostperl_r=lcostperl_r-lcostperl_r[_n-12]
gen d12lcostperl_rl=lcostperl_rl-lcostperl_rl[_n-12]
gen d12lcostperladj_r=lcostperladj_r-lcostperl_r[_n-12]
gen d12lcostperhadj_r=lcostperhadj_r-lcostperl_r[_n-12]
gen d12lentgeltAN_r=lentgeltAN_r-lentgeltAN_r[_n-12]
gen d12lssfrac=lssfrac-lssfrac[_n-12]  /* disapprove, but try anyway */
gen d12lpop=lpop-lpop[_n-12]
gen d12lcons_r=lcons_r-lcons_r[_n-12]
gen d12lgovt_r=lgovt_r-lgovt_r[_n-12]
gen d12linvest_r=linvest_r-linvest_r[_n-12]
gen d12lexports_r=lexports_r-lexports_r[_n-12]
gen d12limports_r=limports_r-limports_r[_n-12]

* counterfactual difference
*gen dlcostperl_r_cnt2003=dlcostperl_r
*sort year
*replace dlcostperl_r_cnt2003=0 if year_q>2003
*label var dlcostperl_r_cnt2003 "counterfactual delta log L costs, after 2003 const"

/* predicting through 2003 */
* set up time-series time variable (has to increment by 1)
* so can do newey-west se's; do 4 quarters of lags

do ~/research/BPEA_recession/statprog/timevar

/* total hours */
reg lhourswork lgdp_r  year_q if year<=2003,cluster(year)
predict lhoursworkhat2003_1
label var lhoursworkhat2003_1 "Predicted log hours worked, no L costs"

* predict total hours worked from gdp and also linear trend AND cost per hour worked
reg lhourswork lgdp_r lcostperh_r  year_q if year<=2003,cluster(year)
predict lhoursworkhat2003_3
label var lhoursworkhat2003_3 "Predicted,1970-2003,x=GDP,hourly L costs"

* adjusted cost per hour
reg lhourswork lgdp_r lcostperhadj_r  year_q if year<=2003,cluster(year)
predict lhoursworkhat2003_3b
label var lhoursworkhat2003_3b "Predicted,1970-2003,x=GDP, adj hourly L costs"

* components of gdp instead of gdp, and pop
reg lhourswork lcons_r linvest_r lgovt_r lexports_r limports_r lcostperhadj_r lpop year_q if year<=2003,cluster(year)
predict lhoursworkhat2003_3c
label var lhoursworkhat2003_3c "Predicted,1970-2003,x=GDP comps, adj hourly L costs"

* use total L costs to avoid any endogeneity
reg lhourswork lgdp_r lentgeltAN_r  year_q if year<=2003,cluster(year)
predict lhoursworkhat2003_4
label var lhoursworkhat2003_4 "Predicted,1970-2003,x=total L costs"

* for completeness, per worker costs
reg lhourswork lgdp_r lcostperl_r  year_q if year<=2003,cluster(year)
predict lhoursworkhat2003_8
label var lhoursworkhat2003_8 "Predicted,1970-2003,x=GDP,per worker L costs"

* now one quarter differences
reg dlhourswork dlgdp_r dlentgeltAN_r if year<=2003,cluster(year)
predict dlhoursworkhat2003_1
label var dlhoursworkhat2003_1 "Predicted,diffs,1970-2003,x=total L costs"
* predict the level
gen lhoursworkhat2003_5=lhourswork if year<=2003
replace lhoursworkhat2003_5=lhoursworkhat2003_5[_n-1]+dlhoursworkhat2003_1 if lhoursworkhat2003_5==.
label var lhoursworkhat2003_5 "Predicted,diffs,1970-2003,x=GDP,total L costs"

* predict the level around the 1974 recession
gen lhoursworkhat2003_1974=lhourswork if year_q<=1974.0
replace lhoursworkhat2003_1974=lhoursworkhat2003_1974[_n-1]+dlhoursworkhat2003_1 if lhoursworkhat2003_1974==.
replace lhoursworkhat2003_1974=. if year_q<=1973.75|year_q>=1977.0
label var lhoursworkhat2003_1974 "Predicted, diffs, 1970-2003, x=hours"

* do with hourly L cost instead of total
reg dlhourswork dlgdp_r dlcostperh_r if year<=2003,cluster(year)
predict dlhoursworkhat2003_2
label var dlhoursworkhat2003_2 "Predicted,diffs,1970-2003,x=hourly L costs"
* predict the level
gen lhoursworkhat2003_6=lhourswork if year<=2003
replace lhoursworkhat2003_6=lhoursworkhat2003_6[_n-1]+dlhoursworkhat2003_2 if lhoursworkhat2003_6==.
replace lhoursworkhat2003_6=. if year_q<=2002.75
label var lhoursworkhat2003_6 "Predicted,diffs,1970-2003,x=GDP,hourly L costs"

* lag gdp
reg dlhourswork dlgdp_rl dlcostperh_r if year<=2003,cluster(year)
* lag gdp and cost
reg dlhourswork dlgdp_rl dlcostperh_rl if year<=2003,cluster(year)

* even though disapprove, put in ss as frac of entgeld
reg dlhourswork dlgdp_r dlcostperh_r dlssfrac if year<=2003,cluster(year)
predict dlhoursworkhat2003_3
label var dlhoursworkhat2003_3 "Predicted,diffs,1970-2003,x=%SS,GDP,hourly L costs"
* predict the level
gen lhoursworkhat2003_7=lhourswork if year<=2003
replace lhoursworkhat2003_7=lhoursworkhat2003_7[_n-1]+dlhoursworkhat2003_3 if lhoursworkhat2003_7==.
label var lhoursworkhat2003_7 "Predicted,diffs,1970-2003,x=%SS,GDP,hourly L costs"

* put value added in the various sectors on rhs instead of gdp comps
reg lhourswork lgdp_r lcostperhadj_r lvaag_r lvaman_r lvacons_r lvatrade_r lvafin_r lvaserv_r  year_q if year<=2003,cluster(year)
testparm lvaag_r-lvaserv_r

/* now employment */
* check just trend
reg lempl year_q if year<=2003,cluster(year) 

* predict total hours worked from gdp and also linear trend
reg lempl lgdp_r  year_q if year<=2003,cluster(year)
predict lemplhat2003_1
label var lemplhat2003_1 "Predicted, 1970-2003, x=GDP,trend"

* predict total employment from gdp and also linear trend AND cost per worker
reg lempl lgdp_r lcostperl_r  year_q if year<=2003,cluster(year)
predict lemplhat2003_3
label var lemplhat2003_3 "Predicted, 1970-2003, x=GDP, L costs per worker"

* repeat with lohnkosten adjusted for KA payments
reg lempl lgdp_r lcostperladj_r  year_q if year<=2003,cluster(year)
newey lempl lgdp_r lcostperladj_r  year_q if year<=2003,lag(4)
predict lemplhat2003_3b
label var lemplhat2003_3b "Predicted, 1970-2003, x=GDP, adj L costs per worker"
* standard errors
predict lemplhat2003_3b_se,stdp
* 95% conf interval
gen lemplhat2003_3b_hi=lemplhat2003_3b+2*lemplhat2003_3b_se
gen lemplhat2003_3b_lo=lemplhat2003_3b-2*lemplhat2003_3b_se

* lag the rhs vars 1 quarter
reg lempl lgdp_rl lcostperladj_rl  year_q if year<=2003,cluster(year)
newey lempl lgdp_rl lcostperladj_rl  year_q if year<=2003,lag(4)
predict lemplhat2003_3f
label var lemplhat2003_3f "Predicted 1L, 1970-2003, x=GDP, adj L costs per worker"
* standard errors
predict lemplhat2003_3f_se,stdp
* 95% conf interval
gen lemplhat2003_3f_hi=lemplhat2003_3f+2*lemplhat2003_3f_se
gen lemplhat2003_3f_lo=lemplhat2003_3f-2*lemplhat2003_3f_se

* have four lags for GDP and wages
reg lempl lgdp_rl lgdp_rl2 lgdp_rl3 lgdp_rl4 lcostperladj_rl lcostperladj_rl2 lcostperladj_rl3 lcostperladj_rl4  year_q if year<=2003,cluster(year)

* four lags for GDP, one for wages
* (since later w lags insig, and same true for manuf)
reg lempl lgdp_rl lgdp_rl2 lgdp_rl3 lgdp_rl4 lcostperladj_rl  year_q if year<=2003,cluster(year)
newey lempl lgdp_rl lgdp_rl2 lgdp_rl3 lgdp_rl4 lcostperladj_rl  year_q if year<=2003,lag(4)
predict lemplhat2003_lags
label var lemplhat2003_lags "Predicted, lags, 1970-2003, x=GDP, adj L costs per worker, lags"
* standard errors
predict lemplhat2003_lags_se,stdp
* 95% conf interval
gen lemplhat2003_lags_hi=lemplhat2003_lags+2*lemplhat2003_lags_se
gen lemplhat2003_lags_lo=lemplhat2003_lags-2*lemplhat2003_lags_se


* do the wage simulations on this
* adding historical trend to w's post 2003
gen lempl_cnt1c=_b[_cons]+_b[lgdp_rl]*lgdp_rl+_b[lgdp_rl2]*lgdp_rl2+_b[lgdp_rl3]*lgdp_rl3+_b[lgdp_rl4]*lgdp_rl4+_b[lcostperladj_rl]*lcostperladj_rcnt1l+_b[year_q]*year_q
replace lempl_cnt1c=. if year_q<=2002.75
label var lempl_cnt1c "Predicted, add trend to L costs"

* use instead -0.1, which Steiner says is the upper bound
* the constant will be wrong, but changes should be correct
gen lempl_cnt1d=_b[_cons]+_b[lgdp_rl]*lgdp_rl+_b[lgdp_rl2]*lgdp_rl2+_b[lgdp_rl3]*lgdp_rl3+_b[lgdp_rl4]*lgdp_rl4-1*lcostperladj_rcnt1l+_b[year_q]*year_q
replace lempl_cnt1d=. if year_q<=2002.75
label var lempl_cnt1d "Predicted, add trend to L costs"

* lag the rhs vars 2 quarters
reg lempl lgdp_rl2 lcostperladj_rl2  year_q if year<=2003,cluster(year)
newey lempl lgdp_rl2 lcostperladj_rl2  year_q if year<=2003,lag(4)
predict lemplhat2003_3e
label var lemplhat2003_3e "Predicted, 1970-2003, x=GDP, adj L costs per worker, lags"

* adding historical trend to w's post 2003
gen lempl_cnt1=_b[_cons]+_b[lgdp_rl2]*lgdp_rl2+_b[lcostperladj_rl2]*lcostperladj_rcnt1l2+_b[year_q]*year_q
replace lempl_cnt1=. if year_q<=2002.75
label var lempl_cnt1 "Predicted, add trend to L costs"

di _b[lcostperladj_rl2]

* do same, but impose labor demand elasticity of -0.7, instead of estimated -0.5
* the constant will be wrong, but changes should be correct
gen lempl_cnt1b=_b[_cons]+_b[lgdp_rl2]*lgdp_rl2-0.7*lcostperladj_rcnt1l2+_b[year_q]*year_q
replace lempl_cnt1b=. if year_q<=2002.75
label var lempl_cnt1b "Predicted, add trend to L costs, e=-0.7"


* make post 2003 wages pure linear historical trend
gen lempl_cnt2=_b[_cons]+_b[lgdp_rl2]*lgdp_rl2+_b[lcostperladj_rl2]*lcostperladj_rcnt2l2+_b[year_q]*year_q
replace lempl_cnt2=. if year_q<=2002.75
label var lempl_cnt2 "Predicted, L costs are trend"

* impose 10% gradual wage decline 2009
gen lempl_cnt3=_b[_cons]+_b[lgdp_rl2]*lgdp_rl2+_b[lcostperladj_rl2]*lcostperladj_rcnt3l2+_b[year_q]*year_q
replace lempl_cnt3=. if year_q<=2008.75
label var lempl_cnt3 "Predicted, 10% LC decline 2009"

* sudden 10% subsidy Q12009-Q1 2010
gen lempl_cnt4=_b[_cons]+_b[lgdp_rl2]*lgdp_rl2+_b[lcostperladj_rl2]*lcostperladj_rcnt4l2+_b[year_q]*year_q
replace lempl_cnt4=. if year_q<=2008.75
label var lempl_cnt4 "Predicted, 10% LC subsidy 2009"


* add population and split gdp into components
reg lempl lcons_r linvest_r lgovt_r lexports_r limports_r lcostperladj_r lpop year_q if year<=2003,cluster(year)
predict lemplhat2003_3c
label var lemplhat2003_3c "Predicted, 1970-2003, x=GDP comps, adj L costs per worker, pop"

* without pop
reg lempl lcons_r linvest_r lgovt_r lexports_r limports_r lcostperladj_r year_q if year<=2003,cluster(year)
predict lemplhat2003_3d
label var lemplhat2003_3d "Predicted, 1970-2003, x=GDP comps, adj L costs per worker"

* instead of hourly L costs, use total (Entgelt), to avoid endogeneity
reg lempl lgdp_r lentgeltAN_r  year_q if year<=2003,cluster(year)
predict lemplhat2003_10
label var lemplhat2003_10 "Predicted, 1970-2003, x=GDP, total L costs"

* just total hours on rhs
reg lempl lhourswork year_q if year<=2003,cluster(year)
predict lemplhat2003_7
label var lemplhat2003_7 "Predicted, 1970-2003, x=hours"

* do in 1-quarter differences
reg dlempl dlgdp_r dlcostperl_r if year<=2003,cluster(year)
predict dlemplhat2003_1
label var dlemplhat2003_1 "Predicted diffs,LC per worker"
* predict the level
gen lemplhat2003_4=lempl if year<=2003
replace lemplhat2003_4=lemplhat2003_4[_n-1]+dlemplhat2003_1 if lemplhat2003_4==.
replace lemplhat2003_4=. if year_q<=2002.75
label var lemplhat2003_4 "Predicted,diffs 1970-2003,x=GDP, L costs per worker"

* same but adjusted LC
reg dlempl dlgdp_r dlcostperladj_r if year<=2003,cluster(year)
predict dlemplhat2003_1b
label var dlemplhat2003_1b "Predicted diffs,LC per worker"
* predict the level
gen lemplhat2003_4b=lempl if year<=2003
replace lemplhat2003_4b=lemplhat2003_4b[_n-1]+dlemplhat2003_1b if lemplhat2003_4b==.
replace lemplhat2003_4b=. if year_q<=2002.75
label var lemplhat2003_4b "Predicted,diffs 1970-2003,x=GDP, adj L costs per worker"


* error correction model
reg dlempl dlgdp_r dlcostperladj_r lempll lgdp_rl lcostperladj_rl if year<=2003,cluster(year)
newey dlempl dlgdp_r dlcostperladj_r lempll lgdp_rl lcostperladj_rl if year<=2003,lag(4)
predict dlemplhat2003_ecm
label var dlemplhat2003_ecm "Predicted diffs, error correction model"
* predict the level
* do for whole period, but anchoring on 2003 Q4
gen lemplhat2003_ecm=lempl if year_q==2003.75
replace lemplhat2003_ecm=lemplhat2003_ecm[_n-1]+dlemplhat2003_ecm if lemplhat2003_ecm==.&year>2003
* to do same thing going backwards is hard if don't reverse sort
gsort -year_q
replace lemplhat2003_ecm=lemplhat2003_ecm[_n-1]-dlemplhat2003_ecm if lemplhat2003_ecm==.&year_q<=2003.5
label var lemplhat2003_ecm "Predicted, error correction model"
gsort +year_q

* standard errors difficult, presumably huge

* repeat with GDP lagged
* lag cost too
reg dlempl dlgdp_rl dlcostperl_rl if year<=2003,cluster(year)

* add population and split gdp into components and use adjusted LC
reg dlempl dlcons_r dlinvest_r dlgovt_r dlexports_r dlimports_r dlcostperladj_r dlpop if year<=2003,cluster(year)
predict dlemplhat2003_1c
label var dlemplhat2003_1c "Predicted diffs,GDP comps"
* predict the level
gen lemplhat2003_4c=lempl if year<=2003
replace lemplhat2003_4c=lemplhat2003_4c[_n-1]+dlemplhat2003_1c if lemplhat2003_4c==.
replace lemplhat2003_4c=. if year_q<=2002.75
label var lemplhat2003_4c "Predicted,diffs 1970-2003,x=GDP comps, L costs per worker"


* in 1-quarter differences but with total labor costs, to avoid endogeneity
reg dlempl dlgdp_r dlentgeltAN_r if year<=2003,cluster(year)
predict dlemplhat2003_4
label var dlemplhat2003_4 "Predicted, 1970-2003, diffs,x=GDP,total L costs"
* predict the level
gen lemplhat2003_11=lempl if year<=2003
replace lemplhat2003_11=lemplhat2003_11[_n-1]+dlemplhat2003_4 if lemplhat2003_11==.
replace lemplhat2003_11=. if year_q<=2002.75
label var lemplhat2003_11 "Predicted, 1970-2003, diffs,x=GDP,total L costs"

* do in 1-quarter differences with just hours work on rhs
reg dlempl dlhourswork if year<=2003,cluster(year)
predict dlemplhat2003_2
label var dlemplhat2003_2 "Predicted diffs, with hourly wage"
* predict the level
gen lemplhat2003_8=lempl if year<=2003
replace lemplhat2003_8=lemplhat2003_8[_n-1]+dlemplhat2003_2 if lemplhat2003_8==.
replace lemplhat2003_8=. if year_q<=2002.75
label var lemplhat2003_8 "Predicted, diffs, 1970-2003, x=hours"

* predict the level around the 1974 recession
gen lemplhat2003_1974=lempl if year_q<=1974.0
replace lemplhat2003_1974=lemplhat2003_1974[_n-1]+dlemplhat2003_2 if lemplhat2003_1974==.
replace lemplhat2003_1974=. if year_q<=1973.75|year_q>=1977.0
label var lemplhat2003_1974 "Predicted, diffs, 1970-2003, x=hours"

* don't difference, but lag gdp one quarter
reg lempl lgdp_rl lcostperl_rl  year_q if year<=2003,cluster(year)
predict lemplhat2003_5
label var lemplhat2003_5 "Predicted, 1970-2003, x=GDP, L costs per worker"

* try one year differences
reg d4lempl d4lgdp_r d4lcostperl_r if year<=2003,cluster(year)
predict d4lemplhat2003_1
label var d4lemplhat2003_1 "Predicted 1yr diffs,LC per worker"
* predict the level
gen lemplhat2003_12=lempl if year<=2003
replace lemplhat2003_12=lemplhat2003_12[_n-4]+d4lemplhat2003_1 if lemplhat2003_12==.
replace lemplhat2003_12=. if year_q<=2002.75
label var lemplhat2003_12 "Predicted,1yr diffs 1970-2003,x=GDP, L costs per worker"

* try two year differences
reg d8lempl d8lgdp_r d8lcostperl_r if year<=2003,cluster(year)
predict d8lemplhat2003_1
label var d8lemplhat2003_1 "Predicted 2yr diffs,LC per worker"
* predict the level
gen lemplhat2003_13=lempl if year<=2003
replace lemplhat2003_13=lemplhat2003_13[_n-8]+d8lemplhat2003_1 if lemplhat2003_13==.
replace lemplhat2003_13=. if year_q<=2002.75
label var lemplhat2003_13 "Predicted,2yr diffs 1970-2003,x=GDP, L costs per worker"

* try three year differences
reg d12lempl d12lgdp_r d12lcostperl_r if year<=2003,cluster(year)
predict d12lemplhat2003_1
label var d12lemplhat2003_1 "Predicted 3yr diffs,LC per worker"
* predict the level
gen lemplhat2003_14=lempl if year<=2003
replace lemplhat2003_14=lemplhat2003_14[_n-12]+d12lemplhat2003_1 if lemplhat2003_14==.
replace lemplhat2003_14=. if year_q<=2002.75
label var lemplhat2003_14 "Predicted,3yr diffs 1970-2003,x=GDP, L costs per worker"

* three year differences and gdp comps
reg d12lempl d12lcons_r d12lgovt_r d12linvest_r d12lexports_r d12limports_r d12lcostperl_r if year<=2003,cluster(year)
predict d12lemplhat2003_2
label var d12lemplhat2003_2 "Predicted 3yr diffs,LC per worker"
* predict the level
gen lemplhat2003_14b=lempl if year<=2003
replace lemplhat2003_14b=lemplhat2003_14b[_n-12]+d12lemplhat2003_2 if lemplhat2003_14b==.
replace lemplhat2003_14b=. if year_q<=2002.75
label var lemplhat2003_14b "Predicted,3yr diffs 1970-2003,x=GDP comps, L costs per worker"


* just total hours on rhs - 1991+ estimation
reg lempl lhourswork year_q if year<=2003&year>=1991,cluster(year)
predict lemplhat2003_15
label var lemplhat2003_15 "Predicted, 1991-2003, x=hours"

* gdp and adj lc/l on rhs - 1991+ estimation
reg lempl lgdp_r lcostperladj_r  year_q if year<=2003&year>=1991,cluster(year)
predict lemplhat2003_16
label var lemplhat2003_16 "Predicted, 1991-2003, x=GDP, adj L costs per worker"

* put value added in the various sectors on rhs instead of gdp comps
* predicts bigger boom, same bust
reg lempl lgdp_r lcostperladj_r lvaag_r lvaman_r lvacons_r lvatrade_r lvafin_r lvaserv_r  year_q if year<=2003,cluster(year)
testparm lvaag_r-lvaserv_r
predict lemplhat2003_17
label var lemplhat2003_17 "Predicted, 1970-2003, x=VA comps, GDP, adj L costs per worker"

/* hours per worker */

* for reference, see what r-squared is with just trend
reg lhrsworker year_q if year<=2003,cluster(year)

reg lhrsworker lhourswork year_q if year<=2003,cluster(year)
predict lhrsworkerhat2003_1
label var lhrsworkerhat2003_1 "Predicted, 1970-2003, x=hours"

* don't use total hours, just L costs
* CURRENTLY DISAPPROVE OF INCLUDING THIS, AT LEAST IF PER HOUR
* DUE TO EXISTENCE OF FIXED COSTS INCL SS,
* CUTTING HOURS PER WORKER RAISES THE HOURLY WAGE, SO WILL LOOK AS THOUGH
* HIGH WAGE CAUSES HOURS PER WORKER TO FALL, BUT CAUSALITY OPPOSITE
* make it cost per worker
reg lhrsworker lcostperl_r year_q if year<=2003,cluster(year)
predict lhrsworkerhat2003_2

* use all
reg lhrsworker lhourswork lcostperl_r year_q if year<=2003,cluster(year)
predict lhrsworkerhat2003_3

* gdp instead of hours work
reg lhrsworker lgdp_r lcostperl_r year_q if year<=2003,cluster(year)
predict lhrsworkerhat2003_10
label var lhrsworkerhat2003_10 "Predicted,1970-2003,x=GDP,per worker L costs"

* my preferred: use 1-quarter differences so gdp or total hours play big role
* then just include (which still need to make quarterly)
* nb if do this CANNOT use SS contribs which are measured annually
* and don't think should use wages
reg dlhrsworker dlgdp_r if year<=2003,cluster(year)
predict dlhrsworkerhat2003_1
* predict the level
gen lhrsworkerhat2003_4=lhrsworker if year<=2003
replace lhrsworkerhat2003_4=lhrsworkerhat2003_4[_n-1]+dlhrsworkerhat2003_1 if lhrsworkerhat2003_4==.
replace lhrsworkerhat2003_4=. if year_q<=2003.5
label var lhrsworkerhat2003_4 "Predicted,diffs 1970-2003,x=GDP"

* also add total L costs
reg dlhrsworker dlgdp_r dlentgeltAN_r if year<=2003,cluster(year)
predict dlhrsworkerhat2003_3
* predict the level
gen lhrsworkerhat2003_8=lhrsworker if year<=2003
replace lhrsworkerhat2003_8=lhrsworkerhat2003_8[_n-1]+dlhrsworkerhat2003_3 if lhrsworkerhat2003_8==.
replace lhrsworkerhat2003_8=. if year_q<=2003.5
label var lhrsworkerhat2003_8 "Predicted,diffs 1970-2003,x=GDP,total L costs"

* L costs per worker instead of total L costs
reg dlhrsworker dlgdp_r dlcostperl_r if year<=2003,cluster(year)
predict dlhrsworkerhat2003_4
* predict the level
gen lhrsworkerhat2003_9=lhrsworker if year<=2003
replace lhrsworkerhat2003_9=lhrsworkerhat2003_9[_n-1]+dlhrsworkerhat2003_4 if lhrsworkerhat2003_9==.
replace lhrsworkerhat2003_9=. if year_q<=2003.5
label var lhrsworkerhat2003_9 "Predicted,diffs 1970-2003,x=GDP,per worker L costs"

tsset,clear
drop timevar
do ~/research/BPEA_recession/statprog/timevar

* adjust for KA payments
reg dlhrsworker dlgdp_r dlcostperladj_r if year<=2003,cluster(year)
newey dlhrsworker dlgdp_r dlcostperladj_r if year<=2003,lag(4)
predict dlhrsworkerhat2003_4b
* predict the level beginning first in 2003, then 2008 Q1
gen lhrsworkerhat2003_9b=lhrsworker if year<=2003
replace lhrsworkerhat2003_9b=lhrsworkerhat2003_9b[_n-1]+dlhrsworkerhat2003_4b if lhrsworkerhat2003_9b==.
replace lhrsworkerhat2003_9b=. if year_q<=2003.5
label var lhrsworkerhat2003_9b "Predicted,diffs 1970-2003,x=GDP,per worker adj L costs"

gen lhrsworkerhat2007_9b=lhrsworker if year_q<=2008
replace lhrsworkerhat2007_9b=lhrsworkerhat2007_9b[_n-1]+dlhrsworkerhat2003_4b if lhrsworkerhat2007_9b==.
replace lhrsworkerhat2007_9b=. if year_q<=2007.75
label var lhrsworkerhat2007_9b "Predicted,diffs 1970-2003,x=GDP,per worker adj L costs"

tsset,clear
drop timevar
do ~/research/BPEA_recession/statprog/timevar

* error correction model
reg dlhrsworker dlgdp_r dlcostperladj_r lhrsworkerl lgdp_rl lcostperladj_rl if year<=2003,cluster(year)
newey dlhrsworker dlgdp_r dlcostperladj_r lhrsworkerl lgdp_rl lcostperladj_rl if year<=2003,lag(4)
predict dlhrsworkerhat2003_ecm
label var dlhrsworkerhat2003_ecm "Predicted diffs, error correction model"
* predict the level

gen lhrsworkerhat2003_ecm=lhrsworker if year_q==2003.75
replace lhrsworkerhat2003_ecm=lhrsworkerhat2003_ecm[_n-1]+dlhrsworkerhat2003_ecm if lhrsworkerhat2003_ecm==.&year>2003
replace lhrsworkerhat2003_ecm=. if year<=2003.5
label var lhrsworkerhat2003_ecm "Predicted, error correction model, from 2004"

gen lhrsworkerhat2007_ecm=lhrsworker if year_q<=2008
replace lhrsworkerhat2007_ecm=lhrsworkerhat2007_ecm[_n-1]+dlhrsworkerhat2003_ecm if lhrsworkerhat2007_ecm==.
replace lhrsworkerhat2007_ecm=. if year_q<=2007.75
label var lhrsworkerhat2007_ecm "Predicted, error correction model, from 2008"


* lagged gdp
reg dlhrsworker dlgdp_rl dlcostperl_r if year<=2003,cluster(year)
* lag cost too
reg dlhrsworker dlgdp_rl dlcostperl_rl if year<=2003,cluster(year)

* hourswork instead of gdp
reg dlhrsworker dlhourswork if year<=2003,cluster(year)
predict dlhrsworkerhat2003_2
* predict the level
gen lhrsworkerhat2003_5=lhrsworker if year<=2003
replace lhrsworkerhat2003_5=lhrsworkerhat2003_5[_n-1]+dlhrsworkerhat2003_2 if lhrsworkerhat2003_5==.
replace lhrsworkerhat2003_5=. if year_q<=2003.5
label var lhrsworkerhat2003_5 "Predicted,diffs 1970-2003,x=hours"

* predict the level around the 1974 recession
gen lhrsworkerhat2003_1974=lhrsworker if year_q<=1974.0
replace lhrsworkerhat2003_1974=lhrsworkerhat2003_1974[_n-1]+dlhrsworkerhat2003_2 if lhrsworkerhat2003_1974==.
*replace lhrsworkerhat2003_1974=. if year_q<=1973.75|year_q>=1977.0
label var lhrsworkerhat2003_1974 "Predicted, diffs, 1970-2003, x=hours"

* level regression, just gdp on rhs
reg lhrsworker lgdp_r year_q if year<=2003,cluster(year)
predict lhrsworkerhat2003_6
label var lhrsworkerhat2003_6 "Predicted, 1970-2003,x=GDP"

* level regressions, gdp and total L costs on rhs
reg lhrsworker lgdp_r lentgeltAN_r year_q if year<=2003,cluster(year)
predict lhrsworkerhat2003_7
label var lhrsworkerhat2003_7 "Predicted, 1970-2003,x=GDP,total L costs"

drop timevar
sort year_q
save /Users/hunt/Desktop/Nervecenter/research/BPEA_recession/data/macro_q,replace


log close
